-- A class to make a selection from a list of values

Selector = class()

function Selector:init(data)
    data = data or {}
    self.list = data.list or self.list or {"a","b","c"}
    self.cur = data.cur or self.cur or 1    -- currently selected index
    self.title = data.title or self.title
    self.tdx = data.tdx or self.tdx or -30
    self.tdy = data.tdy or self.tdy or 0
    self.h = data.h or self.h or 50
    self.w = data.w or self.w or 200
    self.x = data.x or self.x or 300
    self.y = data.y or self.y or 300
    self.fontSize = data.fontSize or self.fontSize or self.h * 0.8
    self.titleFontSize = data.titleFontSize or self.titleFontSize or self.fontSize
    self.bkg = data.bkg or self.bkg or color(230)
    self.frg = data.frg or self.frg or color(0)
    self.stroke = data.stroke or self.stroke or color(100)
    self.strokeWidth = data.strokeWidth or self.strokeWidth or 5
    -- callback is called with 2 arguments: callback( current index , current list value )
    self.callback = data.callback or self.callback or function(v) print(v) end
    -- prepare the image for drawing
    self.img = self:makeImage()
    self.dy = self:update_dy()
    self.visible = true
    -- for touch management
    self.wr = self.w / 2
    self.hr = self.h / 2
    self.xr = self.x + self.wr
    self.yr = self.y + self.hr
    self.sensor = Sensor{parent=self}
    self.sensor:onDrag( function(event) self:drag(event.touch) end )
    self.sensor.enabled = (#self.list~=1)  -- if 1 option only, this is just a text box
end

function Selector:update_dy()
    -- update the image shift from current index value
    self.dy = (self.cur-1) * self.h
    return self.dy
end
function Selector:update_cur()
    -- update current index from dy value
    self.cur = math.floor(self.dy/self.h+1.5)
    if self.cur < 1 then self.cur =1 end
    if self.cur > #self.list then self.cur =#self.list end
end
function Selector:setCur(v)
    self.cur = v
    if self.cur < 1 then self.cur =1 end
    if self.cur > #self.list then self.cur =#self.list end
    self:update_dy()
end
function Selector:setValue(target)
    for i,v in ipairs(self.list) do
        if v == target then
            self:setCur(i)
        end
    end
end
function Selector:makeImage()
    -- an image with all values
    self.htot = self.h * (#self.list)
    self.dyMax = self.htot - self.h
    local img = image(self.w, self.htot)
    local x,y = self.w/2
    setContext(img) 
    do
        background( self.bkg )
        fill(self.frg)
        fontSize(self.fontSize)
        textMode(CENTER)
        for i,v in ipairs(self.list) do
            y = self.h * (i-0.5)
            text( tostring(v) , x,y)
        end
    end 
    setContext()
    return img
end

function Selector:draw()
    if not self.visible then return end
    -- draw the current value
    spriteMode(CORNER)
    clip(self.x,self.y,self.w,self.h)
    sprite(self.img, self.x, self.y-self.dy)
    clip()
    -- add some decoration
    stroke(self.stroke)
    strokeWidth(self.strokeWidth)
    fill(0,0)
    rectMode(CORNER)
    rect(self.x-1,self.y-1,self.w+2,self.h+2)
    -- and the title
    if self.title then
        fontSize(self.titleFontSize)
        fill(self.frg)
        textMode(CORNER)
        text(self.title,self.x+self.tdx, self.y+self.tdy)
    end
end

function Selector:touched(t)
    self.sensor:touched(t)
end

function Selector:drag(t)
    if t.state == MOVING then
        -- drag the image
        self.dy = self.dy - t.deltaY
        if self.dy < 0 then self.dy =0 end
        if self.dy > self.dyMax then self.dy =self.dyMax end
    elseif t.state == ENDED then
        -- when finger released, finalize the value
        self:update_cur()
        self:update_dy()
        self.callback( self.cur , self.list[ self.cur ] )
    end
end


